<?php 

require_once '../config.php';

$action = strip_tags($_POST['action']); 

switch ($action) {
	case 'index':
		index();
		break;

	case 'store':
		store();
		break;

	case 'edit':
		edit();
		break;

	case 'update':
		update();
		break;

	case 'destroy':
		destroy();
		break;	

	case 'logout':
		logout();
		break;
	case 'filterview':
		filterview();
		break;	


    case 'indexFront':

		indexFront();

		break;

	case 'approvalindex':
		approvalindex();
		break;

    case 'setstatus':
		setstatus();
		break;


	// **** added by ayona *******

	case 'getCategoryJobsFrontPage':
		getCategoryJobsFrontPage();
		break;

	case 'getCategoryJobsLandingPage':
		getCategoryJobsLandingPage();
		break;

	case 'getCategoryJobsLandingPageSearch':
		getCategoryJobsLandingPageSearch();
		break;

	case 'postjob':
		postjob();
		break;

	case 'getjobs':
		getjobs();
		break;

	case 'deletePostedJob':
		deletePostedJob();
		break;


	// ****/.added by ayona*******

}


function index(){

	$jobs = new Jobs();
	$all = $jobs->selectAll();

	$page = strip_tags($_POST['page']);
	$limit = 100000;
	$link = SITE_URL.'modules/jobs/?page=';
	$class = 'pagination';

	$Pager = new Pager();
	$query = $jobs->selectAllQuery();
	$Buttons = array('&laquo;', '&raquo;');

	$pagination = '';

	$data = $Pager->pager($query, $page, $limit);
	if(count($all)>$limit){
		$Pager->getPager();
		$pagination .= $Pager->getPagerStyle($Buttons, $class, $link);
	}

	$out = '';
	$modal = '';
	$category_data = Jobs::getJobsCategory();


	foreach ($data as $row) {


		$out .= '<tr id="row'.$row['id'].'">';
		$out .= '<td>'.$row['id'].'</td>';
		$out .= '<td>'.$row['job_title'].'</td>';	
		
		$out .= '<td>'.$row['end_date'].'</td>';

		if ($row['accepted_status'] == 0) {
			$out .= '<td>Pending</td>';
		}else if ($row['accepted_status'] == 1) {
			$out .= '<td>Approved</td>';
		}else{

			$out .= '<td>Declined</td>';
		}



		$out .= '<td>'.$row['created_at'].'</td>';		
		

		$val = Common::getPermissions("jobs","edit");
              if ($val== 1) {  

             	$view = '<a href="'.SITE_URL.'modules/jobs/view.php?id='.$row['id'].'">
		   		<i class="fa fa-eye" aria-hidden="true"></i> </a>'; 

				$editview = '<a href="'.SITE_URL.'modules/jobs/edit.php?id='.$row['id'].'">
		   		<i class="metismenu-icon pe-7s-back-2" aria-hidden="true"></i> </a>';
		   				    }

		   				 $val = Common::getPermissions("jobs","delete");
              if ($val== 1) { 
				$deleteaction = '<a href="javascript:;" class="text-danger"
		  						   onclick="deleteUser('.$row['id'].');"> ';
		  					}


		$out .= '<td> '.$view.'&nbsp; &nbsp; '.$editview.'    	

		     &nbsp; &nbsp;'.$deleteaction.'
		     <i class="metismenu-icon pe-7s-delete-user" aria-hidden="true"></i></a></td>';
		$out .= '</tr>';


	}

	foreach ($data as $row) {
		$modal .= '<div id="delete_'.$row['id'].'" class="modal fade" role="dialog">
				  <div class="modal-dialog">

				    <div class="modal-content">
				      <div class="modal-header">
				        <button type="button" class="close" data-dismiss="modal">&times;</button>
				        <h4 class="modal-title">Delete User</h4>
				      </div>
				      <div class="modal-body">
				        <p>Are you sure you want to delete this user.</p>
				      </div>
				      <div class="modal-footer">
				      <button type="button" class="btn btn-success" data-dismiss="modal">No</button>
				        <button type="button" class="btn btn-danger" onclick="deleteUser('.$row['id'].')">Yes</button>
				      </div>
				    </div>

				  </div>
				</div>';
	}
	// print_r($out);die();
	echo json_encode(array('table'=>$out,'modal'=>$modal,'pagination'=>$pagination));
}

function create(){
  echo 'create';
}

function store(){

	//print_r($_POST);die();

	$date = date("Y-m-d H:i:s");

	$data = $_POST;
   
    $data['end_date'] = date("Y-m-d", strtotime($_POST['end_date']));	


	$data['created_at'] = $date;
	$data['created_by'] = Sessions::getAdminFullName();

	$jobs = new Jobs();
	$insert  = $jobs->store($data);

	if($insert){
		// $activity_log = new ActivityLog();
		// $activity_log->newLogRecord('jobs','add','Jobs Added.');
		echo 200;
	}else{
		echo 400;
	}
}

function show(){
  echo 'show';
}

function edit(){
  echo 'edit';
}

function update(){

	date_default_timezone_set('Asia/Colombo');
	$date = date("Y-m-d H:i:s");

	$data = $_POST;

   $data['start_date'] = date("Y-m-d", strtotime($_POST['start_date']));	
   $data['end_date'] = date("Y-m-d", strtotime($_POST['end_date']));

	// print_r($data);die();
	$data['updated_at'] = $date;

	$jobs = new Jobs();
	$updates = $jobs->update($data);

	if($updates){
		$activity_log = new ActivityLog();
		$activity_log->newLogRecord('jobs','edit','Jobs Edited.');
		echo 200;
	}else{
		echo 400;
	}
}

function destroy(){
	
	$jobs = new Jobs();
	$delete = $jobs->delete(strip_tags($_POST['id']));

	if($delete){
		$activity_log = new ActivityLog();
		$activity_log->newLogRecord('jobs','delete','Jobs Deleted.');
		echo 200;
	}else{
		echo 400;
	}
}



function logout(){

	Sessions::logoutAdmin();
	echo 200;
}

function filterview(){

    $filterid = strip_tags($_POST['id']);
   

    $jobs = new Jobs();
	$all = $jobs->selectAllbyId($filterid);

  

	$page = strip_tags($_POST['page']);
	$limit = 100000;
	$link = SITE_URL.'jobs/?page=';
	$class = 'pagination';

	$Pager = new Pager();
	$query = $jobs->selectAllQuerybyJobs($filterid);

  

	$Buttons = array('&laquo;', '&raquo;');

	$pagination = '';

	$data = $Pager->pager($query, $page, $limit);
	if(count($all)>$limit){
		$Pager->getPager();
		$pagination .= $Pager->getPagerStyle($Buttons, $class, $link);
	}

	$out = '';
	$modal = '';
	foreach ($data as $row) {

		$out .= '<tr id="row'.$row['id'].'">';
		$out .= '<td>'.$row['id'].'</td>';
		$out .= '<td>'.$row['name'].'</td>';
		$out .= '<td>'.$row['amount'].'</td>';
		$out .= '<td>'.$row['created_at'].'</td>';
		

		if ($row['type']=="1") {
			$out .= '<td>'."Percentage".'</td>';
		}else{
			$out .= '<td>'."Value".'</td>';
		}
		

		$val = Common::getPermissions("jobs","edit");
              if ($val== 1) {  

				$editview = '<a href="'.SITE_URL.'modules/jobs/edit.php?id='.$row['id'].'">
		   		<i class="fa fa-pencil-square-o fa-lg" aria-hidden="true"></i> </a>';
		   				    }

		   				 $val = Common::getPermissions("jobs","delete");
              if ($val== 1) { 
				$deleteaction = '<a href="javascript:;" class="text-danger"
		  						   onclick="deleteUser('.$row['id'].');"> ';
		  					}


		$out .= '<td> '.$editview.'    	

		     &nbsp; &nbsp;'.$deleteaction.'
		     <i class="fa fa-times fa-lg" aria-hidden="true"></i></a></td>';
		$out .= '</tr>';


	}

	foreach ($data as $row) {
		$modal .= '<div id="delete_'.$row['id'].'" class="modal fade" role="dialog">
				  <div class="modal-dialog">

				    <div class="modal-content">
				      <div class="modal-header">
				        <button type="button" class="close" data-dismiss="modal">&times;</button>
				        <h4 class="modal-title">Delete User</h4>
				      </div>
				      <div class="modal-body">
				        <p>Are you sure you want to delete this user.</p>
				      </div>
				      <div class="modal-footer">
				      <button type="button" class="btn btn-success" data-dismiss="modal">No</button>
				        <button type="button" class="btn btn-danger" onclick="deleteUser('.$row['id'].')">Yes</button>
				      </div>
				    </div>

				  </div>
				</div>';
	}
	echo json_encode(array('table'=>$out,'modal'=>$modal,'pagination'=>$pagination));

	
}

function indexFront(){ 



	//print_r($_POST);die();



	$jobs = new Jobs();



	$page = strip_tags($_POST['page']);

	$limit = 9;



	$jscallback = 'loadData';

	$class = 'pagination';



	$Pager = new PagerJs();



//****** by deafault load data *******


	if($_POST['search_word'] == NULL && $_POST['anc_status'] == NULL && $_POST['category_id'] == NULL  && $_POST['major_id'] == NULL && $_POST['industry_id'] == NULL && $_POST['employment_type'] == NULL && $_POST['prof_level'] == NULL){

		

		$query = $jobs->selectAllQuerySearchFront();

		$all = $jobs->selectAllSearchFront();

		



		 

//******* type search by student no ******

	}else if(!empty($_POST['search_word'])){      

		

		

		$query = $jobs->selectAllQuerySearchFrontSearch($_POST["search_word"]);

		$all = $jobs->selectAllSearchFrontSearch($_POST["search_word"]);






		
//******* filter selected search *******

	}else if(($_POST['anc_status']!== NULL) || ($_POST['category_id']!== NULL) || ($_POST['major_id']!== NULL) || ($_POST['industry_id']!== NULL) || ($_POST['employment_type']!== NULL) || ($_POST['prof_level']!== NULL)){



		



		$query = $jobs->selectAllQuerySearchFrontSearchCategory($_POST["anc_status"],$_POST["category_id"],$_POST['major_id'],$_POST['industry_id'],$_POST['employment_type'],$_POST['prof_level']);



		$all = $jobs->selectAllSearchFrontSearchCategory($_POST["anc_status"],$_POST["category_id"],$_POST['major_id'],$_POST['industry_id'],$_POST['employment_type'],$_POST['prof_level']);



	 

	}





	$Buttons = array('&laquo;', '&raquo;');



	$pagination = '';



	$data = $Pager->pager($query, $page, $limit);

	if(count($all)>$limit){

		$Pager->getPager();

		$pagination .= $Pager->getPagerStyle($Buttons, $class, $jscallback);

	}



	$out = '';





	//print_r($data);die();



	if (empty($data)) {

    $emptytitle = '<h4>No Result Found</h4>';

	}



		   



          foreach ($data as $key) {

          	

              //loop data here

        //   	 $major = new Major();
 		     // $major_data = $major->getById($key['major']);

 		     // $industry = new Industry();
 		     // $industry_data = $industry->getById($key['industry']);               

    


		     $companies = new Companies();
 		     $companies_data = $companies->getById($key['company_id']);


                      
          $out .=' <div class="col-md-4 mb-3">
      <div class="job-card">
                <div class="job-card-header d-flex justify-content-between align-items-center">
                  <div class="job-card-header-title">
                    <h5>
                      <a href="#">
                        <span class="dept">Marketing</span>
                        <span class="designation text-success">'.$key['job_title'].'</span>
                      </a>
                    </h5>
                    <div class="meta">
                      <span class="text-muted">Published: '.$key['start_date'].'</span>
                    </div>
                  </div>


                  <div class="job-card-header-logo">
                    <img src="admin/uploads/companies/propic/'.$companies_data[0]['propic'].'" alt="">
                  </div>
                </div>


                <div class="job-card-body">
                  <p class="no-trunc">'.$key['job_description'].'</p>
                </div>

                <div class="job-card-footer d-flex justify-content-between">
                  <span class="small text-muted">'.$companies_data[0]['name'].'</span>
                  <span class="small text-muted">Deadline: '.$key['end_date'].'</span>
                </div>
              </div>
      </div>';
               

                   



          ///proceed button on header

            $bt = '<div class="add-button pull-right">

			<a href="company_dashboard.php" class="btn btn-default btn-warning btn-lg"><span id="student_count"><h4>'.$_SESSION["count"].'</h4></span>Proceed</a>

			</div>';

              



          }

	

	



	echo json_encode(array('table'=>$out,'pagination'=>$pagination,'countbtn'=>$bt,'emptytitle'=>$emptytitle));

}


function approvalindex(){

	$jobs = new Jobs();
	$all = $jobs->selectAll();

	$page = strip_tags($_POST['page']);
	$limit = 100000;
	$jscallback = 'loadData';
	$class = 'pagination';

	$Pager = new PagerJs();
	$query = $jobs->selectAllQueryforApproval();
	$Buttons = array('&laquo;', '&raquo;');

	$pagination = '';

	$data = $Pager->pager($query, $page, $limit);
	if(count($all)>$limit){
		$Pager->getPager();
		$pagination .= $Pager->getPagerStyle($Buttons, $class, $jscallback);
	}

	$out = '';
	$modal = '';
	$view = '';
	foreach ($data as $row) {

		$out .= '<tr id="row'.$row['id'].'">';
		$out .= '<td>'.$row['id'].'</td>';
		$out .= '<td>'.$row['job_title'].'</td>';

		$cdata = new Companies();
		$company_data = $cdata->selectAlldata();

		//print_r($company_data[0][name]);


		foreach ($company_data as $key) {	

		if ($key[id] == $row[company_id]) {
				$comname =  $key[name];

			}	
			
		}


		$out .= '<td>'.$comname.'</td>';


		
		$out .= '<td>'.$row['end_date'].'</td>';
		$out .= '<td>'.$row['created_at'].'</td>';       

        
        $out .='</td>';		


		$out .= '<td><select id="status" name="status" class="form-control" onchange="setstatus(' . $row['id'] . ',this.value)">

		 <option '; 
		 $out.=($row['status'] == 0) ? 'selected="selected"' : ''; 
		 $out.=' value="0">Pending</option>
		 <option ';
		 $out.= ($row['status'] == 1) ? 'selected="selected"' : ''; 
		 $out.=' value="1">Aproved</option>
		 <option ';
		 $out.= ($row['status'] == 2) ? 'selected="selected"' : ''; 
		 $out.=' value="2">Declined</option>

		 </select>';
		 $out.='<div id="'.$row['id'].'status_msg"><div></td>';
	

		$val = Common::getPermissions("jobs","edit");
              if ($val== 1) {  

				$editview = '<a href="'.SITE_URL.'modules/jobs/edit.php?id='.$row['id'].'">
		   		<i class="metismenu-icon pe-7s-back-2" aria-hidden="true"></i> </a>';
		   				    }

		   				 $val = Common::getPermissions("jobs","delete");
              if ($val== 1) { 
				$deleteaction = '<a href="javascript:;" class="text-danger"
		  						   onclick="deleteUser('.$row['id'].');"> ';
		  					}

		  		 $view = '<a href="'.SITE_URL.'modules/jobs/view.php?id='.$row['id'].'">
		   		<i class="fa fa-eye" aria-hidden="true"></i> </a>'; 


		$out .= '<td>'.$view.'&nbsp; &nbsp; '.$editview.'    	

		     &nbsp; &nbsp;'.$deleteaction.'
		     <i class="metismenu-icon pe-7s-delete-user" aria-hidden="true"></i></a></td>';
		$out .= '</tr>';


	}

	foreach ($data as $row) {
		$modal .= '<div id="delete_'.$row['id'].'" class="modal fade" role="dialog">
				  <div class="modal-dialog">

				    <div class="modal-content">
				      <div class="modal-header">
				        <button type="button" class="close" data-dismiss="modal">&times;</button>
				        <h4 class="modal-title">Delete User</h4>
				      </div>
				      <div class="modal-body">
				        <p>Are you sure you want to delete this user.</p>
				      </div>
				      <div class="modal-footer">
				      <button type="button" class="btn btn-success" data-dismiss="modal">No</button>
				        <button type="button" class="btn btn-danger" onclick="deleteUser('.$row['id'].')">Yes</button>
				      </div>
				    </div>

				  </div>
				</div>';
	}
	echo json_encode(array('table'=>$out,'modal'=>$modal,'pagination'=>$pagination));
}



function setstatus(){

	 $data = $_POST;

	 // $password = password_generate(4);
	 // $data['password'] = $password;

	 $jobs = new Jobs();
	 $insert  = $jobs->setAsStatus($data);

	 // 	 if ($data['status']==1) {
	 // 	//email send to user		

  //    	$data['code'] = 'company_approved';
		// $data['title'] = 'You Have Added to ANC Student Portal';
		// $data['to'] = $data['email'];
		// $data['cc'] = '';
		// $data['bcc'] = '';

		// $data['values'] = array(
		//                   'USERNAME' => $data['email'],
		//                   'PASSWORD' => $password,
		//                   'COMPANY' => $data['name']
		//             	);
	
		
		// $mail = new Emailtemplates();
		// $sendemail = $mail->sendEmail($data);

		//  }

	 $activity_log = new ActivityLog();
	 $activity_log->newLogRecord('jobs','edit','jobs Status Updated.');

	
	 echo $data['id'];

}


// ****************** added by ayona *********************************

function getCategoryJobsFrontPage(){

	$category_id = $_POST['catid'];

	// print_r($category_id);die();

	if ($category_id == 0) {
		$jobs_data = new Jobs();
		$jobs = $jobs_data->selectAllLatest();
	}else{
		$jobs_data = new Jobs();
		$jobs = $jobs_data->getJobsToCategory($category_id);
	}

	$jobsCart = '';

	foreach ($jobs as  $job) { 

		$experience_array = Jobs::getExperienceArray();
		$i = $job['experience'];
		$experience = $experience_array[$i];

		$employement_array = Jobs::getEmploymentArray();
		$j = $job['employment_type'];
		$type = $employement_array[$j];

		$company = new Companies();
        $company_data = $company->selectById($job['company_id']);
        // print_r($job['location_id']);

        $locations = new Jobs();
		$location_data = $locations->selectDistricById($job['location_id']);


		$jobsCart .= '<div class="col-md-3 col-sm-2 col-12 wow animated fadeInUp float-left" data-wow-delay=".3s">
							<input type="hidden" name="catid" id="catid" value="'.$category_id.'"/>
                                <div class="single-team-widget">
                                    <div class="team-member-info">
                                        <div class="job-profile d-flex flex-row">
                                            <div class="profile-image" style="background-image: url('.SITE_URL.'uploads/companies/propic/'.$company_data[0]['propic'].')">
                                                
                                            </div>
                                            <div class="profile-details">
                                                <h3>'.$company_data[0]['name'].'</h3>
                                                <p class="location"><i class="mdi mdi-map-marker"></i><span>'.$location_data[0]['name'].'</span></p>
                                            </div>
                                        </div>
                                        <div class="job-profile-mid">
                                            <h4 class="job-title">'.$job['job_title'].'</h4>
                                            <p>'.substr($job['job_description'], 0, 65).'... </p>
            
                                            <div class="profile-mid-btn d-flex justify-content-between">
                                                <p class="experience"><span>Experience: + '.$experience.' Year</span></p>
                                                <p class="job-cat"><span>'.$type.'</span></p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="job-widget-bottom d-flex justify-content-start">
                                        <div class="apply-btn">
                                            <a href="single-job.php?id='.$job['id'].'" ><p>Apply Job</p></a>
                                        </div>
                                        <div class="view-btn">
                                            <a href="single-job.php?id='.$job['id'].'"><p>View Job</p></a>
                                        </div>
                                    </div>
                                </div>
                            </div>';
	}

	echo json_encode(array('jobsCart'=>$jobsCart,'catid'=>$category_id));

}

function getCategoryJobsLandingPage(){

	$category_id = $_POST['catid'];

	if ($category_id == 0) {
		$jobs_data = new Jobs();
		$jobs = $jobs_data->selectAllLatestForLandingPage();
	}else{
		$jobs_data = new Jobs();
		$jobs = $jobs_data->getJobsToCategoryForLandingPage($category_id);
	}

	$jobsCart = '';

	foreach ($jobs as  $job) { 

		$company = new Companies();
        $company_data = $company->selectById($job['company_id']);
        // print_r($job['location_id']);

        $locations = new Jobs();
		$location_data = $locations->selectDistricById($job['location_id']);

		$experience_array = Jobs::getExperienceArray();
		$i = $job['experience'];
		$experience = $experience_array[$i];

		$employement_array = Jobs::getEmploymentArray();
		$j = $job['employment_type'];
		$type = $employement_array[$j];


        // if ($job['employment_type'] == 0) {
        //     $type = ' Part Time';
        // }else if ($job['employment_type'] == 1) {
        //     $type = ' Full Time';
        // }else if ($job['employment_type'] == 2) {
        //     $type = 'Intern';
        // }

        $jobsCart .= '<div class="col-md-4 col-sm-12 col-12 wow animated fadeInUp float-left" data-wow-delay=".3s">
                            <div class="single-team-widget">
                                <div class="team-member-info">
                                    <div class="job-profile d-flex flex-row">
                                        <div class="profile-image" style="background-image: url('.SITE_URL.'uploads/companies/propic/'.$company_data[0]['propic'].')">
                                            
                                        </div>
                                        <div class="profile-details">
                                            <h3>'.$company_data[0]['name'].'</h3>
                                            <p class="location"><i class="mdi mdi-map-marker"></i><span>'.$location_data[0]['name'].'</span></p>
                                        </div>
                                    </div>
                                    <div class="job-profile-mid">
                                        <h4 class="job-title">'.$job['job_title'].'</h4>
                                        <p>'.substr($job['job_description'], 0, 65).'... </p>
        
                                        <div class="profile-mid-btn d-flex justify-content-between">
                                            <p class="experience"><span>Experience: +'.$experience.' Year</span></p>
                                            <p class="job-cat"><span>'.$type.'</span></p>
                                        </div>
                                    </div>
                                </div>
                                <div class="job-widget-bottom d-flex justify-content-start">
                                    <div class="apply-btn">
                                        <a href="single-job.php?id='.$job['id'].'" ><p>Apply Job</p></a>
                                    </div>
                                    <div class="view-btn">
                                        <a href="single-job.php?id='.$job['id'].'"><p>View Job</p></a>
                                    </div>
                                </div>
                            </div>
                        </div>';



	}

	$categories = new Jobcategory();

	$search_category = '';

	if ($category_id != 0) {
		$category_data = $categories->selectAllbyId($category_id);

		$search_category = '<h5 class="filter-head">Results for</h5><div class="selected-job">
                            <a >
                            <div class="cat-img-wrapper">
                                    <img src="images/category/hr.png" class="img-fluid">    
                                </div>
                                <div class="cat-name-wrapper">
                                     
                                   '.$category_data[0]['name'].'
                                    
                                </div>
                            </a>     
                    </div> ';
	}

	$all_categories_div = '';

	$categories = new Jobcategory();
	$all_categories = $categories->selectAll();

	foreach ($all_categories as $category) {
		if ($category['id'] != $category_id) {

			$all_categories_div .= '<div class="all-job">
                            <a onclick="loadCategoryJob('.$category['id'].')">
                            <div class="cat-img-wrapper">
                                    <img src="images/category/fashion.png" class="img-fluid">    
                                </div>
                                <div class="cat-name-wrapper">
                                     
                                        '.$category['name'].'
                                    
                                </div>
                            </a>     
                    </div>  ';
		}
	}



	echo json_encode(array('jobsCart'=>$jobsCart,'catid'=>$category_id,'search_category'=>$search_category,'all_categories' =>$all_categories_div));

}

function getCategoryJobsLandingPageSearch(){
	$category_id = $_POST['catid'];
	$job_title = $_POST['jobTitle'];
	$job_location = $_POST['jobLocation'];
	$jobs_data = new Jobs();

	if ($category_id == '' && $job_title == '' && $job_location == '') {
		// $jobs_data = new Jobs();
		$jobs = $jobs_data->selectAllLatestForLandingPage();

	}else if($category_id != '' && $job_title == '' && $job_location == ''){

		$jobs = $jobs_data->getJobsToCategoryForLandingPage($category_id);

	}else if($category_id != '' && $job_location != '' && $job_title == ''){

		$jobs = $jobs_data->getJobsToCategoryAndLocForLandingPage($category_id,$job_location);

	}else if ($category_id == '' && $job_location != '' && $job_title == '') {

		$jobs = $jobs_data->getJobsToLocForLandingPage($job_location);

	}else if($category_id != '' && $job_location == '' && $job_title != ''){

		$jobs = $jobs_data->getJobsToCatAndSearchForLandingPage($category_id,$job_title);

	}else if ($category_id == '' && $job_location == '' && $job_title != '') {

		$jobs = $jobs_data->getJobsToSearchJobForLandingPage($job_title);

	}else if ($category_id == '' && $job_location != '' && $job_title != '') {
		
		$jobs = $jobs_data->getJobsToSearchJobAndLocForLandingPage($job_location , $job_title);

	}else if ($category_id != '' && $job_location != '' && $job_title != '') {

		$jobs = $jobs_data->getJobsToAllSearchJobForLandingPage($category_id,$job_location , $job_title);
	}

	$jobsCart = '';

	foreach ($jobs as  $job) { 

		$company = new Companies();
        $company_data = $company->selectById($job['company_id']);

        $locations = new Jobs();
		$location_data = $locations->selectDistricById($job['location_id']);

		$experience_array = Jobs::getExperienceArray();
		$i = $job['experience'];
		$experience = $experience_array[$i];

		$employement_array = Jobs::getEmploymentArray();
		$j = $job['employment_type'];
		$type = $employement_array[$j];

        // if ($job['employment_type'] == 0) {
        //     $type = ' Part Time';
        // }else if ($job['employment_type'] == 1) {
        //     $type = ' Full Time';
        // }else if ($job['employment_type'] == 2) {
        //     $type = 'Intern';
        // }

        $jobsCart .= '<div class="col-md-4 col-sm-12 col-12 wow animated fadeInUp float-left" data-wow-delay=".3s">
                            <div class="single-team-widget">
                                <div class="team-member-info">
                                    <div class="job-profile d-flex flex-row">
                                        <div class="profile-image" style="background-image: url('.SITE_URL.'uploads/companies/propic/'.$company_data[0]['propic'].')">
                                            
                                        </div>
                                        <div class="profile-details">
                                            <h3>'.$company_data[0]['name'].'</h3>
                                            <p class="location"><i class="mdi mdi-map-marker"></i><span>'.$location_data[0]['name'].'</span></p>
                                        </div>
                                    </div>
                                    <div class="job-profile-mid">
                                        <h4 class="job-title">'.$job['job_title'].'</h4>
                                        <p>'.substr($job['job_description'], 0, 65).'... </p>
        
                                        <div class="profile-mid-btn d-flex justify-content-between">
                                            <p class="experience"><span>Experience: +'.$experience.' Year</span></p>
                                            <p class="job-cat"><span>'.$type.'</span></p>
                                        </div>
                                    </div>
                                </div>
                                <div class="job-widget-bottom d-flex justify-content-start">
                                    <div class="apply-btn">
                                        <a href="single-job.php?id='.$job['id'].'" ><p>Apply Job</p></a>
                                    </div>
                                    <div class="view-btn">
                                        <a href="single-job.php?id='.$job['id'].'"><p>View Job</p></a>
                                    </div>
                                </div>
                            </div>
                        </div>';



	}

	$categories = new Jobcategory();

	$search_category = '';

	if ($category_id != 0) {
		$category_data = $categories->selectAllbyId($category_id);

		$search_category = '<h5 class="filter-head">Results for</h5><div class="selected-job">
                            <a onclick="loadCategoryJob('.$category_id.')">
                            <div class="cat-img-wrapper">
                                    <img src="images/category/hr.png" class="img-fluid">    
                                </div>
                                <div class="cat-name-wrapper">
                                     
                                   '.$category_data[0]['name'].'
                                    
                                </div>
                            </a>     
                    </div> ';
	}

	$all_categories_div = '';

	$categories = new Jobcategory();
	$all_categories = $categories->selectAll();

	foreach ($all_categories as $category) {
		if ($category['id'] != $category_id) {

			$all_categories_div .= '<div class="all-job">
                            <a onclick="loadCategoryJob('.$category['id'].')">
                            <div class="cat-img-wrapper">
                                    <img src="images/category/fashion.png" class="img-fluid">    
                                </div>
                                <div class="cat-name-wrapper">
                                     
                                        '.$category['name'].'
                                    
                                </div>
                            </a>     
                    </div>  ';
		}
	}



	echo json_encode(array('jobsCart'=>$jobsCart,'catid'=>$category_id,'search_category'=>$search_category,'all_categories' =>$all_categories_div));
}

function postjob(){
	// print_r($_POST);die();
	$data  = $_POST;

	$company_id = $_SESSION['company_id'];

	$data['id'] = $company_id;
	$date = date("Y-m-d H:i:s");
	$data['created_at'] = $date;

	$data['end_date'] = date("Y-m-d", strtotime($_POST['datepicker']));	

	// print_r($data);die();

	$jobs = new Jobs();
	$job = $jobs->postJob($data);

	if($job){
		echo 200;
	}else{
		echo 400;
	}
}


function getjobs(){

	$company_id = $_SESSION['company_id'];

	$jobs = new Jobs();
	$jobs_data = $jobs->selectJobsForCompany($company_id);

	$posted_job_div = '';

	
	// echo $type_data;

	foreach ($jobs_data as $job) {
		
		$status_types = Jobs::getAcceptedStatus();

		$i = $job['accepted_status'];

		if ($i == 0) {
			$style_class = "yellow";
		}else if ($i == 1) {
			$style_class = "green";
		}else{
			$style_class = "red";
		}
		// $status =$i;
		$status = $status_types[$i];

		$posted_job_div .= '<div class="job-record col-12 float-left">
                                                 
                                                <div class="job-profile-detail-wrapper col-md-4 col-sm-12  col-12 float-left">
                                                     <h2 class="all-job-title">
                                                           '.$job['job_title'].'
                                                     </h2>    
                                                 </div>
                                                 
                                                
                                                 <div class=" col-md-2 col-sm-12  col-12 float-left">
                                                     <span class="start-date">
                                                       '.$job['created_at'].'
                                                     </span>
                                                </div>

                                                <div class=" col-md-2 col-sm-12  col-12 float-left">
                                                    <span class="closing-date">
                                                       '.$job['end_date'].'
                                                    </span>
                                               </div>

                                                <div class=" col-md-2 col-sm-12  col-12 float-left">
                                                      
                                                    <span class="status  '.$style_class.'">
                                                         '.$status.'
                                                    </span>  

                                                 </div>

                                                 <div class=" col-md-2 col-sm-12  col-12 float-left remove-wrapper">
                                                      
                                                    <a class="btn btn-common" onclick="deletePostedJob('.$job['id'].');">
                                                        Remove 
                                                    </a>  

                                                 </div>
                                                
                                            </div>';

	}

	echo json_encode(array('posted_job'=>$posted_job_div));

}

function deletePostedJob(){
	$data = $_POST;
	$id = $data['id'];
	
	// print_r($data);die();
	
	$jobs_data = new Jobs();

	$accedpted_status = $jobs_data->getById($id);

	if ($accedpted_status[0]['accepted_status'] == 0) {
		$job = $jobs_data->deletePostedJob($id);

		if($job){
			echo 200;
		}else{
			echo 400;
		}
	}else{
		echo 300;
	}

	

}


// ******************/. added by ayona *******************************

?>