<?php 

require_once DOC_ROOT.'vendor/autoload.php';

use Medoo\Medoo;

class Products
{
	private $table_name = "products";
	protected $connection;

	function __construct()
	{
		$database = new medoo([
		    'database_type' => 'mysql',
		    'database_name' => DB_NAME,
		    'server' => DB_HOST,
		    'username' => DB_USER,
		    'password' => DB_PASS,
		    'charset' => 'utf8'
		]); 

		$this->connection = $database;
	}

	function store($data){
		$status = $this->connection->insert($this->table_name, [              
            "products_category" => strip_tags($data['products_category']),
            "products_subcategory" => strip_tags($data['products_subcategory']),
            "description" => strip_tags($data['description']),
            "product_title" => strip_tags($data['product_title']),           
            "product_subtitle" => strip_tags($data['product_subtitle']),
            "price" => strip_tags($data['price']),
             "status" => strip_tags($data['status']),
              "propic1" => strip_tags($data['propic1']), 
               "propic2" => strip_tags($data['propic2']),                          
            "created_at" => strip_tags($data['created_at'])
        ]);

        return $status;
	}

	function update($data){

			$status = $this->connection->update($this->table_name, [	        
	          "products_category" => strip_tags($data['products_category']),
            "products_subcategory" => strip_tags($data['products_subcategory']),
            "description" => strip_tags($data['description']),
            "product_title" => strip_tags($data['product_title']),           
            "product_subtitle" => strip_tags($data['product_subtitle']),
            "price" => strip_tags($data['price']),
              "status" => strip_tags($data['status']),
               "propic1" => strip_tags($data['propic1']), 
               "propic2" => strip_tags($data['propic2']),          	            
	          "updated_at" => strip_tags($data['updated_at'])
	        ], ["id" => strip_tags($data['id'])]);
	    

        return $status;
	}

	function updateStatus($status,$id){
		$status = $this->connection->update($this->table_name, [
            "status" => $status
            
        ], ["id" => $id]);
        return $status;
	}

		function delete($id){

            date_default_timezone_set('Asia/Colombo');
            $date = date("Y-m-d H:i:s");
            
            $status = $this->connection->update($this->table_name, [
            "deleted_at" => $date
            
        ], ["id" => $id]);
        return $status;
      }

	function selectAll(){

		$data = $this->connection->select($this->table_name, '*', 'WHERE deleted_at IS NULL ORDER BY id DESC');
		return $data;
	}

	function selectAllbyId($id){

		$data = $this->connection->select($this->table_name, '*', "WHERE deleted_at IS NULL AND id=$id");
		return $data;
	}

	function selectAllQuery(){
		return "SELECT * FROM $this->table_name WHERE deleted_at IS NULL ORDER BY id DESC" ;
	}

	function selectAllQuerybyProducts($id){
		return "SELECT * FROM $this->table_name WHERE deleted_at IS NULL AND type=$id " ;
	}

	function getById($id){

		$data = $this->connection->select($this->table_name, '*', " WHERE deleted_at IS NULL AND id=$id ");
		return $data;
	}
	function getusernamebyid($id){

		$data = $this->connection->select($this->table_name, '*', " WHERE deleted_at IS NULL AND id=$id ");
		return $data;
	}

	static function getProductsCategory(){
            return array("O/L", "A/L","Bachelor","Masters","Doctor");
      }


       static function getEmploymentArray()
      {
            return array(
                  "Part time",
                  "Full time",
                  "Intern"
            );
      }


       static function getExperienceArray()
      {
            return array(
                  "1",
                  "2",
                  "3",
                  "4",
                  "5",
                  "6",
                  "7",
                  "8",
                  "9",                 
                  "10"
            );
      }

       static function getAcceptedStatus(){
            return array("Pending","Approved","Declined");
      }

      function selectAllQueryforApproval(){
            return "SELECT * FROM $this->table_name WHERE accepted_status=0 OR accepted_status=2 AND deleted_at IS NULL ORDER BY id DESC" ;
      }

       function selectAllQuerySearchFront(){
            return "SELECT * FROM $this->table_name WHERE accepted_status = 1 AND deleted_at IS NULL ORDER BY rand()";
      }


  	function selectAllSearchFront(){           
            $data = $this->connection->query("SELECT * FROM $this->table_name WHERE accepted_status = 1 AND deleted_at IS NULL ORDER BY rand()")->fetchAll();
            return $data;
      }


       function selectAllQuerySearchFrontSearch($search_txt){

    
       $search_txt = Common::textToSQLLikeString($search_txt);
     
        return "SELECT * FROM $this->table_name WHERE (id $search_txt OR id $search_txt) AND accepted_status = 1 AND deleted_at IS NULL ORDER BY id DESC";      

           
      }


        function selectAllSearchFrontSearch($search_txt){  

       $search_txt = Common::textToSQLLikeString($search_txt);

          $data = $this->connection->query("SELECT * FROM $this->table_name WHERE (id $search_txt OR id $search_txt) AND accepted_status = 1 AND deleted_at IS NULL ORDER BY id DESC")->fetchAll();
            return $data;


      }


        //Three parameters

      function selectAllQuerySearchFrontSearchCategory($status,$category,$major,$industry,$employment,$professional){           
         
          $where="";           

          // if ($status!="") {
          //    $where .= " anc_status=$status AND ";
          // } 

          // if ($category!="") {
          //    $where .= " FIND_IN_SET($category,jobcategory) AND ";
          // }

          //  if ($major!="") {
          //    $where .= " major=$major AND ";
          // } 

          if ($industry!="") {
             $where .= " industry=$industry AND ";
          }

          if ($employment!="") {
             $where .= " FIND_IN_SET($employment,employment_type) AND ";
          }   

          if ($professional!="") {
             $where .= " FIND_IN_SET($professional,prof_level) AND ";
          }        
         
     
        return "SELECT * FROM $this->table_name WHERE $where accepted_status = 1 AND deleted_at IS NULL ORDER BY id DESC";      

           
      }


  function selectAllSearchFrontSearchCategory($status,$category,$major,$industry,$employment,$professional){

          $where="";       

          // if ($status!="") {
          //    $where .= " anc_status=$status AND ";
          // } 

          // if ($category!="") {
          //    $where .= " FIND_IN_SET($category,jobcategory) AND ";
          // } 

          // if ($major!="") {
          //    $where .= " major=$major AND ";
          // } 

          if ($industry!="") {
             $where .= " industry=$industry AND ";
          }

          if ($employment!="") {
             $where .= " FIND_IN_SET($employment,employment_type) AND ";
          }   

          if ($professional!="") {
             $where .= " FIND_IN_SET($professional,prof_level) AND ";
          }    

          $data = $this->connection->query("SELECT * FROM $this->table_name WHERE $where accepted_status = 1 AND deleted_at IS NULL ORDER BY id DESC")->fetchAll();
            return $data;


      }


        function selectAllDistric(){           
            $data = $this->connection->query("SELECT * FROM districts")->fetchAll();
            return $data;
      }



       
      function setAsStatus($data){
            $status = $this->connection->update($this->table_name, [            
            "accepted_status" => strip_tags($data['status'])
            
        ], ["id" => strip_tags($data['id'])]);
        return $status;
      }

         // ***********************added by ayona*******************************

      function selectAllLatest(){
        // $date = date("Y-m-d");
        // print_r($date);die();
        $data = $this->connection->select($this->table_name, '*', " WHERE deleted_at IS NULL AND accepted_status=1 AND end_date >= CURDATE() ORDER BY id DESC LIMIT 8");
        return $data;

      }


      function getProductsToCategory($category_id){

        $data = $this->connection->select($this->table_name, '*', " WHERE deleted_at IS NULL AND accepted_status=1 AND job_category=$category_id AND end_date >= CURDATE() ORDER BY id DESC LIMIT 8");
        return $data;
      
      }


      function selectDistricById($location_id){

         $data = $this->connection->query("SELECT * FROM districts WHERE id=$location_id")->fetchAll();
         return $data;

      }

      function getNoOfProductsByCatId($category_id){

        $data = $this->connection->select($this->table_name, '*', " WHERE deleted_at IS NULL AND end_date >= CURDATE() AND  accepted_status=1 AND job_category=$category_id");
        return $data;

      }

      function selectAllLatestForLandingPage(){
         $data = $this->connection->select($this->table_name, '*', " WHERE deleted_at IS NULL AND accepted_status=1 AND end_date >= CURDATE() ORDER BY id DESC");
        return $data;
      }

      function getProductsToCategoryForLandingPage($category_id){

        $data = $this->connection->select($this->table_name, '*', " WHERE deleted_at IS NULL AND accepted_status=1 AND job_category=$category_id AND end_date >= CURDATE() ORDER BY id DESC");
        return $data;
      }

      function getProductsToCategoryAndLocForLandingPage($category_id,$job_location){

        $data = $this->connection->select($this->table_name, '*', " WHERE deleted_at IS NULL AND accepted_status=1 AND job_category=$category_id AND location_id=$job_location AND end_date >= CURDATE() ORDER BY id DESC");
        return $data;

      }

      function getProductsToLocForLandingPage($job_location){

        $data = $this->connection->select($this->table_name, '*', " WHERE deleted_at IS NULL AND accepted_status=1 AND location_id=$job_location AND end_date >= CURDATE() ORDER BY id DESC");
        return $data;

      }

      function getProductsToCatAndSearchForLandingPage($category_id,$job_title){
        $search_txt = Common::textToSQLLikeString($job_title);

        $data = $this->connection->select($this->table_name, '*', " WHERE deleted_at IS NULL AND accepted_status=1 AND job_category=$category_id AND end_date >= CURDATE() AND  job_title  $search_txt ORDER BY id DESC");
        return $data;

      }

      function getProductsToSearchJobForLandingPage($job_title){
        $search_txt = Common::textToSQLLikeString($job_title);

        $data = $this->connection->select($this->table_name, '*', " WHERE deleted_at IS NULL AND accepted_status=1 AND end_date >= CURDATE() AND job_title  $search_txt ORDER BY id DESC");
        return $data;
      }

      function getProductsToSearchJobAndLocForLandingPage($job_location , $job_title){

        $search_txt = Common::textToSQLLikeString($job_title);

        $data = $this->connection->select($this->table_name, '*', " WHERE deleted_at IS NULL AND accepted_status=1 AND end_date >= CURDATE() AND location_id=$job_location AND job_title  $search_txt ORDER BY id DESC");
        return $data;

      }

      function getProductsToAllSearchJobForLandingPage($category_id, $job_location , $job_title){

        $search_txt = Common::textToSQLLikeString($job_title);

        $data = $this->connection->select($this->table_name, '*', " WHERE deleted_at IS NULL AND accepted_status=1 AND end_date >= CURDATE() AND job_category=$category_id AND location_id=$job_location AND job_title  $search_txt ORDER BY id DESC");
        return $data;

      }

      function postJob($data){
        $status = $this->connection->insert($this->table_name, [              
            "company_id" => strip_tags($data['id']),
            "job_title" => strip_tags($data['job_title']),
            "job_description" => strip_tags($data['job_description']),
            "job_category" => strip_tags($data['job_category']),           
            "employment_type" => strip_tags($data['employment_type']),
            "location_id" => strip_tags($data['location_id']),
            "experience" => strip_tags($data['experience']),           
            "end_date" => strip_tags($data['end_date']),
            "created_at" => strip_tags($data['created_at'])
        ]);

        return $status;
      }

      function selectProductsForCompany($company_id){

        $data = $this->connection->select($this->table_name, '*', " WHERE deleted_at IS NULL AND  company_id=$company_id ORDER BY id DESC");
        return $data;

      }

      function deletePostedJob($id){
        date_default_timezone_set('Asia/Colombo');
            $date = date("Y-m-d H:i:s");
            
            $status = $this->connection->update($this->table_name, [
            "deleted_at" => $date
            
        ], ["id" => $id]);
        return $status;
      }


      // **************************/.added by ayona*********************************


        function selectAllProductCategory(){           
            $data = $this->connection->query("SELECT * FROM products_category")->fetchAll();
            return $data;
      }

        function selectAllProductSubCategory($id){           
            $data = $this->connection->query("SELECT * FROM products_subcategory WHERE cat_id=$id ")->fetchAll();
            return $data;
      }

	

}

?>